kPPS = 40;               -- Number of particles generated per second
kGravity =1000 ;         -- Gravity in pixels/second/second

function Init()
  SetTexture("smoke");
  SetBlendMode(kBlendNormal);
  SetNumParticles(200);
end

floor = math.floor
ParticlesPerSecond = NewParticleGenerator();

function Update(ms)
  local newParticles = ParticlesPerSecond( kPPS,ms );

	InitPosition( "vRange", Vec3(-35, -10), Vec3(35, 10) );
	InitVelocity( "vRange", Vec3(-40,10), Vec3(40,40) );
	InitScale( "fRange", 0.5, 1 );
	InitAge("iRange", 0, 0);
	CreateParticles(newParticles);

	Gravity(-.15* kGravity);

	Do("move");
	DoAge("iAge");
	DoColor("cFade",
      Color(1, 1,1, 1), 1500,
      Color(1, 1, 1, 0), 500,
      Color(1, 1, 1, 0));
	DoScale("fScale",
      .85, 1500,
      .70, 1500);
	Do("expire", 1800)

	DoUp( "vRotate", -.2, .2 );
end

